'use strict';

define(['app'], function(app) {
	app.controller("addonJetBackupMC", ["$scope", "lang", "api", "util", "alert", function ($scope, lang, api, util, alert) {
		$scope.pluginDetails = {};
		$scope.pluginData = {};
		$scope.pluginAlert ={};
		$scope.pluginConnection = {};

		api.papi = function(func, options) {
			if(options.data === undefined) options.data = {};
			api.pluginAPI('JetBackupMC', func, options);
		};

		$scope.updateConnection = function() {

			var apiParams = util.saveParams($scope.pluginData, $scope.pluginDetails);

			api.papi('checkConnection', {
				data: apiParams,
				failed: function (message) {
					alert.error(message);
				},
				success: function (data, message) {
					$scope.pluginAlert = data;
					$scope.pluginConnection = util.duplicateObject($scope.pluginAlert);
					alert.success(message);
				}
			});
		};


		api.papi('getSettings', {
			success: function (data) {
				$scope.pluginDetails = data;
				$scope.pluginData = util.duplicateObject($scope.pluginDetails);
			}
		});

		api.papi('checkConnection', {
			success: function (data) {
				$scope.pluginAlert = data;
				$scope.pluginConnection = util.duplicateObject($scope.pluginAlert);
			}
		});

	}]);

	app.controller("addonJetBackupMC_Extra", ["$scope", "lang", "api", function ($scope, lang, api) {
	}]);
});