'use strict';

define(['app'], function(app) {

	app.controller("destinationDropBox", ["$scope", "api", "alert", function ($scope, api, alert) {

		$scope.$emit('options', { disklimit: true, threads: true });

		if($scope.details._id === undefined) $scope.saveData.threads = 60;
		if($scope.saveData.options.path === undefined) $scope.saveData.options.path = '/';
		if($scope.saveData.options.authorization_code === undefined) $scope.saveData.options.authorization_code = '';
		if($scope.saveData.options.auth_id === undefined) $scope.saveData.options.auth_id = '';
		if($scope.saveData.options.retries === undefined) $scope.saveData.options.retries = 5;

		$scope.openAuthentication = function() {

			api.genDestinationAuth({
				data: { type: 'pkce' },
				success: function(data) {

					var client_id = 'zkkk6t8uhu9umtk';

					$scope.saveData.options.auth_id = data._id;

					console.log(data);
					
					var url = [];
					url.push('response_type=code');
					url.push('token_access_type=offline');
					url.push('client_id=' + client_id);
					url.push('redirect_uri=https://auth.jetbackup.com/dropbox/');
					url.push('code_challenge=' + data.key);
					url.push('code_challenge_method=S256');

					var features = [];
					features.push('height=500');
					features.push('width=650');
					features.push('left=' + (screen.width / 2 - 225));
					features.push('top=' + (screen.height / 2 - 250));
					features.push('toolbar=no');
					features.push('titlebar=no');
					features.push('status=no');
					features.push('scrollbars=no');
					features.push('resizable=yes');
					features.push('menubar=no');

					window.open("https://dropbox.com/oauth2/authorize?" + url.join('&'), '', features.join(','));
				},
				failed: function (message) {
					alert.error(message);
				}

			});
			

			return false;
		};

	}]);

});