'use strict';

define(['app'], function(app) {

	app.controller("destinationSSH", ["$scope", "lang", function ($scope, lang) {

		$scope.authtype = $scope.saveData.options.privatekey ? 1 : 0;
		if($scope.saveData.options.path === undefined) $scope.saveData.options.path = '/';
		if($scope.saveData.options.port === undefined) $scope.saveData.options.port = 22;
		if($scope.saveData.options.timeout === undefined) $scope.saveData.options.timeout = 60;
		if($scope.saveData.options.rsyncbwlimit === undefined) $scope.saveData.options.rsyncbwlimit = 0;
		if($scope.saveData.options.rsyncpreferip === undefined) $scope.saveData.options.rsyncpreferip = 0;

		$scope.$watch('saveData.options', function() {
			if($scope.authtype == 0) $scope.saveData.options.privatekey = '';
			else $scope.saveData.options.password = '';
		}, true);

		$scope.limit_options = [
			{ label: lang.t("Unlimited"), value: 0 },
			{ label: "256 KB/s", value: 256 },
			{ label: "512 KB/s", value: 512 },
			{ label: "1 MB/s", value: 1024 },
			{ label: "2 MB/s", value: 2048 },
			{ label: "3 MB/s", value: 3072 },
			{ label: "4 MB/s", value: 4096 },
			{ label: "5 MB/s", value: 5120 },
			{ label: "6 MB/s", value: 6144 },
			{ label: "7 MB/s", value: 7168 },
			{ label: "8 MB/s", value: 8192 },
			{ label: "9 MB/s", value: 9216 },
			{ label: "10 MB/s", value: 10240 },
			{ label: "15 MB/s", value: 15360 },
			{ label: "20 MB/s", value: 20480 },
			{ label: "25 MB/s", value: 25600 },
			{ label: "30 MB/s", value: 30720 },
			{ label: "35 MB/s", value: 35840 },
			{ label: "40 MB/s", value: 40960 },
			{ label: "45 MB/s", value: 46080 },
			{ label: "50 MB/s", value: 51200 },
			{ label: "60 MB/s", value: 61440 },
			{ label: "70 MB/s", value: 71680 },
			{ label: "80 MB/s", value: 81920 },
			{ label: "90 MB/s", value: 92160 },
			{ label: "100 MB/s", value: 102400 }
		];

		$scope.preferip_options = [
			{ label: lang.t("Default Route"), value: 0 },
			{ label: "IPv4", value: 4 },
			{ label: "IPv6", value: 6 }
		];
	}]);

});