'use strict';

define(['app'], function(app) {

	app.controller("notificationMicrosoftTeams", ["$scope", "lang", "api", "alert", function ($scope, lang, api, alert) {

		$scope.getAuthCode = function () {
			var tenant_id = $scope.saveData.options.tenant_id;
			var client_id = $scope.saveData.options.client_id;

			if(!tenant_id) {
				alert.error(lang.t("You must provide tenant id first"));
				return;
			}

			if(!client_id) {
				alert.error(lang.t("You must provide client id first"));
				return;
			}

			var url = "https://login.microsoftonline.com";
			url += "/" + tenant_id;
			url += "/oauth2/authorize?";
			url += "client_id=" + client_id;
			url += "&response_type=code";
			url += "&response_mode=query";
			url += "&scope=https://graph.microsoft.com/ChannelMessage.Send+Channel.ReadBasic.All+Channel.Create+offline_access";

			window.open(
				url,
				"Microsoft Teams Auth Code",
				"scrollbars=no,resizable=no,status=no,location=no,toolbar=no,menubar=no,width=400,height=528"
			);

		};
	}]);

});