'use strict';

define(['app'], function(app) {
	app.controller("addonManageDatabases", ["$scope", "lang", "api", "util", "alert", function ($scope, lang, api, util, alert) {
		$scope.options = { tab: 'assign' };

		$scope.pluginDetails = {};
		$scope.pluginData = {};

		api.papi = function(func, options) {
			if(options.data === undefined) options.data = {};
			api.custom('Plugin/ManageDatabases/' + String(func).charAt(0).toUpperCase() + String(func).slice(1), options);
		};

		$scope.saveSettings = function() {

			var apiParams = util.saveParams($scope.pluginData, $scope.pluginDetails);

			api.papi('manageSettings', {
				data: apiParams,
				failed: function (message) {
					alert.error(message);
				},
				success: function (data, message) {
					$scope.pluginDetails = util.duplicateObject($scope.pluginData);
					alert.success(message);
				}
			});
		};

		api.papi('getSettings', {
			success: function (data) {
				$scope.pluginDetails = data;
				$scope.pluginData = util.duplicateObject($scope.pluginDetails);
			}
		});
	}]);

	app.controller("addonManageDatabases_Assign", ["$scope", "$q", "lang", "api", "util", "alert", "popup", function ($scope, $q, lang, api, util, alert, popup) {
		
		$scope.allDatabases = {};
		$scope.allDatabaseUsers = {};
		$scope.autocomplete = { accountText: '' }
		$scope.selectedAccount = {};
		$scope.type = 1;
		$scope.statistics = {
			databases: {
				1: {dbs:{assigned:0,unassigned:0,total:0},users:{assigned:0,unassigned:0,total:0}},
				2: {dbs:{assigned:0,unassigned:0,total:0},users:{assigned:0,unassigned:0,total:0}},
				3: {dbs:{assigned:0,unassigned:0,total:0},users:{assigned:0,unassigned:0,total:0}}
			}
		};

		$scope.types_select = [
			{label:lang.t("MySQL"),value:1},
			{label:lang.t("MongoDB"),value:2},
			{label:lang.t("PostgreSQL"),value:3}
		];
		
		$scope.resetLists = function () {
			$scope.list = {
				databases: { assigned: [], unassigned: [] },
				users: { assigned: [], unassigned: [] }
			};

			$scope.searchTerm = {
				databases: { assigned: "", unassigned: "" },
				users: { assigned: "", unassigned: "" }
			};

			$scope.search = {
				databases: { assigned: [], unassigned: [] },
				users: { assigned: [], unassigned: [] }
			};
		};

		$scope.resetLists();

		$scope.types = {
			1: 'MySQL',
			2: 'MongoDB',
			3: 'PostgreSQL'
		};

		$scope.$watch('searchTerm.databases.unassigned', function () {
			var q = $scope.searchTerm.databases.unassigned;
			for(var i in $scope.list.databases.unassigned) {
				var details = $scope.search.databases.unassigned[i];
				details.hidden = q && !RegExp(q).test(details.name);
			}
		});
		
		$scope.$watch('searchTerm.databases.assigned', function () {
			var q = $scope.searchTerm.databases.assigned;
			for(var i in $scope.list.databases.assigned) {
				var details = $scope.search.databases.assigned[i];
				details.hidden = q && !RegExp(q).test(details.name);
			}
		});

		$scope.$watch('searchTerm.users.unassigned', function () {
			var q = $scope.searchTerm.users.unassigned;
			for(var i in $scope.list.users.unassigned) {
				var details = $scope.search.users.unassigned[i];
				details.hidden = q && !RegExp(q).test(details.name);
			}
		});

		$scope.$watch('searchTerm.users.assigned', function () {
			var q = $scope.searchTerm.users.assigned;
			for(var i in $scope.list.users.assigned) {
				var details = $scope.search.users.assigned[i];
				details.hidden = q && !RegExp(q).test(details.name);
			}
		});

		$scope.selectAccount = function(account) {
			if(account === undefined) return;
			$scope.selectedAccount = account;
			$scope.autocomplete.accountText = account.username;

			$scope.fetchDatabases($scope.type, function () {
				for(var database in $scope.allDatabases[$scope.type]) {
					if(!$scope.allDatabases[$scope.type][database]) {
						$scope.list.databases.unassigned.push(database);
						$scope.search.databases.unassigned.push({ name: database, hidden: false });
					}
					else if($scope.allDatabases[$scope.type][database] === account.username) {
						$scope.list.databases.assigned.push(database);
						$scope.search.databases.assigned.push({ name: database, hidden: false });
					}
				}

				for(var user in $scope.allDatabaseUsers[$scope.type]) {
					if(!$scope.allDatabaseUsers[$scope.type][user]) {
						$scope.list.users.unassigned.push(user);
						$scope.search.users.unassigned.push({ name: user, hidden: false });
					}
					else if($scope.allDatabaseUsers[$scope.type][user] === account.username) {
						$scope.list.users.assigned.push(user);
						$scope.search.users.assigned.push({ name: user, hidden: false });
					}
				}
			});
		};

		$scope.searchAccounts = function(query) {
			if(!query) return [];
			var deferred = $q.defer();
			api.listAccounts({ 
				data: { 
					login_only: 0, 
					filter: query, 
					sort: { username: 1 } 
				},
				success: function(data) {
					var results = [];
					for(var i = 0; i < data.accounts.length; i++) results.push(data.accounts[i]);
					deferred.resolve( results );
				}
			});

			return deferred.promise;
		};

		$scope.manageAccounts = function() {

			popup.open({
				template: 'accountSelection',
				scope: $scope,
				resolve: {
					account: function() { return ''; }
				}
			}).result.then(function(account) {
				$scope.selectAccount(account);
			}, function () {});

		};

		$scope.assignDatabase = function (database) {
			var position = $scope.list.databases.unassigned.indexOf(database);
			if(position < 0) return;
			$scope.list.databases.unassigned.splice(position, 1);
			$scope.search.databases.unassigned.splice(position, 1);
			$scope.list.databases.assigned.push(database);
			var q = $scope.searchTerm.databases.assigned;
			$scope.search.databases.assigned.push({ name: database, hidden: q && !RegExp(q).test(database) });
		};

		$scope.unassignDatabase = function (database) {
			var position = $scope.list.databases.assigned.indexOf(database);
			if(position < 0) return;
			$scope.list.databases.assigned.splice(position, 1);
			$scope.search.databases.assigned.splice(position, 1);
			$scope.list.databases.unassigned.push(database);
			var q = $scope.searchTerm.databases.unassigned;
			$scope.search.databases.unassigned.push({ name: database, hidden: q && !RegExp(q).test(database) });
		};

		$scope.assignDatabaseUser = function (user) {
			var position = $scope.list.users.unassigned.indexOf(user);
			if(position < 0) return;
			$scope.list.users.unassigned.splice(position, 1);
			$scope.search.users.unassigned.splice(position, 1);
			$scope.list.users.assigned.push(user);
			var q = $scope.search.assigned;
			$scope.search.users.assigned.push({ name: user, hidden: q && !RegExp(q).test(user) });
		};

		$scope.unassignDatabaseUser = function (user) {
			var position = $scope.list.users.assigned.indexOf(user);
			if(position < 0) return;
			$scope.list.users.assigned.splice(position, 1);
			$scope.search.users.assigned.splice(position, 1);
			$scope.list.users.unassigned.push(user);
			var q = $scope.search.unassigned;
			$scope.search.users.unassigned.push({ name: user, hidden: q && !RegExp(q).test(user) });
		};

		$scope.fetchDatabases = function(type, callback) {

			$scope.resetLists();
			
			if(type === undefined) type = 0;
			if(callback === undefined) callback = function() {};
			
			api.papi('listDatabases', {
				data: { type: type },
				failed: function (message) {
					callback();
					alert.error(message);
				},
				success: function (data) {
					$scope.allDatabases = data.databases;

					api.papi('listDatabaseUsers', { 
						data: { type: type },
						failed: function (message) {
							callback();
							alert.error(message);
						},
						success: function (data) {
							$scope.allDatabaseUsers = data.users;
							callback();
						}
					});
				}
			});
		};

		$scope.reassign = function() {

			api.papi('DatabaseAssign', { 
				data: { type: $scope.type, list: $scope.list, account: $scope.selectedAccount.username },
				failed: function (message) {
					alert.error(message);
				},
				success: function (data, message) {
					alert.success(message);
				}
			});
			
		};

		$scope.fetchStatistics = function () {
			api.papi('GetStatistics', {
				success: function (data) {
					$scope.statistics = data;
				}
			});
			
		};
		
		$scope.fetchStatistics();

	}]);
	
	app.controller("addonManageDatabases_Settings", [function () {}]);

	app.controller("addonManageDatabases_CreateAccount", ["$uibModalInstance", "$uibModal", "$scope", "$timeout", "api", "lang", "alert", function ($uibModalInstance, $uibModal, $scope, $timeout, api, lang, alert) {

			$scope.pluginData = { account: '' };

			$scope.ok = function () {
				
				api.papi('createAccount', { 
					data: { account: $scope.pluginData.account },
					failed: function (message) {
						alert.error(message);
					},
					success: function () {
						$uibModalInstance.close($scope.pluginData.account);
					}
				})
			};

			$scope.cancel = function () {
				$uibModalInstance.dismiss(lang.t('cancel'));
			};
		
		}]);
});